"use strict";

exports.__esModule = true;
exports.default = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _Element = _interopRequireDefault(require("./Element"));

var _Parser = _interopRequireDefault(require("./Parser"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; subClass.__proto__ = superClass; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var Markup = function (_React$PureComponent) {
  _inheritsLoose(Markup, _React$PureComponent);

  function Markup() {
    return _React$PureComponent.apply(this, arguments) || this;
  }

  var _proto = Markup.prototype;

  _proto.getContent = function getContent() {
    var _this$props = this.props,
        content = _this$props.content,
        emptyContent = _this$props.emptyContent,
        parsedContent = _this$props.parsedContent,
        tagName = _this$props.tagName,
        props = _objectWithoutPropertiesLoose(_this$props, ["content", "emptyContent", "parsedContent", "tagName"]);

    if (parsedContent) {
      return parsedContent;
    }

    var markup = new _Parser.default(content || '', props).parse();
    return markup.length > 0 ? markup : null;
  };

  _proto.render = function render() {
    var content = this.getContent() || this.props.emptyContent;
    var tag = this.props.tagName || 'div';
    return tag === 'fragment' ? _react.default.createElement(_react.default.Fragment, null, content) : _react.default.createElement(_Element.default, {
      tagName: tag
    }, content);
  };

  return Markup;
}(_react.default.PureComponent);

exports.default = Markup;

_defineProperty(Markup, "propTypes", {
  content: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.oneOf([null])]),
  emptyContent: _propTypes.default.node,
  parsedContent: _propTypes.default.node,
  tagName: _propTypes.default.oneOfType([_propTypes.default.oneOf(['fragment']), _propTypes.default.string])
});

_defineProperty(Markup, "defaultProps", {
  content: '',
  emptyContent: null,
  parsedContent: null,
  tagName: 'div'
});